<?php

include APPLICATION_PATH . '/DAO/FicheSmsDAO.php';
include APPLICATION_PATH . '/DAO/UtilisateurDAO.php';
include APPLICATION_PATH . '/DAO/ProfilDAO.php';
include APPLICATION_PATH . '/DAO/PersonneDAO.php';
include APPLICATION_PATH . '/DAO/LogDAO.php';
include APPLICATION_PATH . '/DAO/DroitDAO.php';
include APPLICATION_PATH . '/DAO/MenuDAO.php';
include PUBLIC_PATH . '/Fonctions/Fonction.php';
include PUBLIC_PATH . '/files_to_include/Constantes.php';

class SmsController extends Zend_Controller_Action
{

    public function init()
    {
        session_start();
        if ( isset($_SESSION["idUtilisateur"])){
            $_SESSION["derniereAction"] = new \DateTime();
        }else{
            $this->_helper->redirector('index' , 'Index');
        }
    }

    public function indexAction()
    {
        try{
          $ficheDao = new FicheepidemioDAO();
          $connection = $ficheDao->_em->getConnection();
          $sql = " CREATE OR REPLACE VIEW fiches AS SELECT f.formSanitaire AS formation , concat(f.formSanitaire,'_',f.semaineEpidemio) AS id,  f.nbConsultTotal AS nbConsult,f.nbAffectFebrile as nbFebrile, f.nbIRA AS nbIra,f.nbSG AS nbSg,f.semaineEpidemio AS semaine "
                 . " FROM ficheepidemio f "
                  . "group by f.formSanitaire,f.semaineEpidemio ";
          $requete = $connection->prepare($sql);
          $requete->execute();
       } catch (Exception $ex) {
          echo $ex->getMessage() . " Si cela persiste veuillez contacter l'administateur";
          exit();
       }
    }


  public function informationAction(){
      if(!empty($_POST)){
          $formSanitaire = $_POST["formSanitaire"];
          $semaineEpidemio = $_POST["semaineEpidemio"];
          $ficheDao = new FicheepidemioDAO();
           $fiche= $ficheDao->getFiche($semaineEpidemio, $formSanitaire);
           $result = array("formSanitaire"=>$fiche->getFormsanitaire(),"semaineEpidemio"=>$fiche->getSemaineepidemio(),"nbconsulttotal"=>$fiche->getNbconsulttotal(),
               "nbaffectfebrile"=>$fiche->getNbaffectfebrile(),"nbira"=>$fiche->getNbira(),"nbsg"=>$fiche->getNbsg(),
               "nbconsultants1"=>$fiche->getNbconsultants1(),"nbfebrile1"=>$fiche->getNbfebrile1(),"nbira1"=>$fiche->getNbira1(),"nbsg1"=>$fiche->getNbsg1(),
                "nbconsultants2"=>$fiche->getNbconsultants2(),"nbfebrile2"=>$fiche->getNbfebrile2(),"nbira2"=>$fiche->getNbira2(),"nbsg2"=>$fiche->getNbsg2(),
                "nbconsultants3"=>$fiche->getNbconsultants3(),"nbfebrile3"=>$fiche->getNbfebrile3(),"nbira3"=>$fiche->getNbira3(),"nbsg3"=>$fiche->getNbsg3(),
                "nbconsultants4"=>$fiche->getNbconsultants4(),"nbfebrile4"=>$fiche->getNbfebrile4(),"nbira4"=>$fiche->getNbira4(),"nbsg4"=>$fiche->getNbsg4(),
                "nbconsultants5"=>$fiche->getNbconsultants5(),"nbfebrile5"=>$fiche->getNbfebrile5(),"nbira5"=>$fiche->getNbira5(),"nbsg5"=>$fiche->getNbsg5(),
               "nbecouvnano"=>$fiche->getNbecouvnano(),"nbecouvbucco"=>$fiche->getNbecouvbucco());
          echo json_encode(array("type"=>"success","data"=>$result));
          exit();
      }else{
          echo json_encode(array("type"=>"error","data"=>"Paramètres incorrects"));
          exit();
      }
      
  }

    public function editerAction()
    {
        if ( !empty($_POST)){
            //Initialisation
            $formSanitaire = trim($_POST["formSanitaire"]);
            $semaineEpidemio = trim($_POST["semaineEpidemio"]);
            $nbEcouvnano = (int)$_POST["nbEcouvnano"];
            $nbEcouvbucco = (int)$_POST["nbEcouvbucco"];
            $nbConsultTotal = (int)$_POST["nbConsultTotal"];
            $nbAffectFebrile = (int)$_POST["nbAffectFebrile"];
            $nbIra = (int)$_POST["nbIra"];
            $nbSg = (int)$_POST["nbSg"];
            //Consultation
            $nbConsultants1 = (int)$_POST["nbConsultants1"];
            $nbConsultants2 = (int)$_POST["nbConsultants2"];
            $nbConsultants3 = (int)$_POST["nbConsultants3"];
            $nbConsultants4 = (int)$_POST["nbConsultants4"];
            $nbConsultants5 = (int)$_POST["nbConsultants5"];
            //Febrile
            $nbfebrile1 = (int)$_POST["nbfebrile1"];
            $nbfebrile2 = (int)$_POST["nbfebrile2"];
            $nbfebrile3 = (int)$_POST["nbfebrile3"];
            $nbfebrile4 = (int)$_POST["nbfebrile4"];
            $nbfebrile5 = (int)$_POST["nbfebrile5"];
            
            //IRa
            $nbIra1 = (int)$_POST["nbIra1"];
            $nbIra2 = (int)$_POST["nbIra2"];
            $nbIra3 = (int)$_POST["nbIra3"];
            $nbIra4 = (int)$_POST["nbIra4"];
            $nbIra5 = (int)$_POST["nbIra5"];
            
            //nbSg
            $nbSg1 = (int)$_POST["nbSg1"];
            $nbSg2 = (int)$_POST["nbSg2"];
            $nbSg3 = (int)$_POST["nbSg3"];
            $nbSg4 = (int)$_POST["nbSg4"];
            $nbSg5 = (int)$_POST["nbSg5"];
            
           $ficheDao = new FicheepidemioDAO();
           $fiche = $ficheDao->getFiche($semaineEpidemio, $formSanitaire);
            if ( !is_object($fiche)){
                echo json_encode(array("type" => "error" , "message" => "Fiche de la semaine (" . $semaineEpidemio." et du site ".$formSanitaire. ") inexistante"));
                exit();
            }else{
                //Total
                if( $fiche->getNbconsulttotal()!=$nbConsultTotal){
                    $fiche->setNbconsulttotal($nbConsultTotal);
                }
                if( $fiche->getNbaffectfebrile()!=$nbAffectFebrile){
                    $fiche-> setNbaffectfebrile($nbAffectFebrile);
                }
                 if( $fiche->getNbira()!=$nbIra){
                    $fiche->setNbira($nbIra);
                }
                if( $fiche->getNbsg()!=$nbSg){
                    $fiche->setNbsg($nbSg);
                }
                //Consultation
               if( $fiche->getNbconsultants1()!=$nbConsultants1){
                    $fiche->setNbconsultants1($nbConsultants1);
                }
                if( $fiche->getNbconsultants2()!=$nbConsultants2){
                    $fiche->setNbconsultants2($nbConsultants2);
                }
                if( $fiche->getNbconsultants3()!=$nbConsultants3){
                    $fiche->setNbconsultants3($nbConsultants3);
                }
                if( $fiche->getNbconsultants4()!=$nbConsultants4){
                    $fiche->setNbconsultants4($nbConsultants4);
                }
                if( $fiche->getNbconsultants5()!=$nbConsultants5){
                    $fiche->setNbconsultants5($nbConsultants5);
                }
                //Febrile
                if( $fiche->getNbfebrile1()!=$nbfebrile1){
                    $fiche->setNbfebrile1($nbfebrile1);
                }
                if( $fiche->getNbfebrile2()!=$nbfebrile2){
                    $fiche->setNbfebrile2($nbfebrile2);
                }
                if( $fiche->getNbfebrile3()!=$nbfebrile3){
                    $fiche->setNbfebrile3($nbfebrile3);
                }
                if( $fiche->getNbfebrile4()!=$nbfebrile4){
                    $fiche->setNbfebrile4($nbfebrile4);
                }
                if( $fiche->getNbfebrile5()!=$nbfebrile5){
                    $fiche->setNbfebrile5($nbfebrile5);
                }
                
                //Ira
                if( $fiche->getNbira1()!=$nbIra1){
                    $fiche->setNbira1($nbIra1);
                }
                 if( $fiche->getNbira2()!=$nbIra2){
                    $fiche->setNbira2($nbIra2);
                }
                 if( $fiche->getNbira3()!=$nbIra3){
                    $fiche->setNbira3($nbIra3);
                }
                if( $fiche->getNbira4()!=$nbIra4){
                    $fiche->setNbira4($nbIra4);
                }
                if( $fiche->getNbira5()!=$nbIra5){
                    $fiche->setNbira5($nbIra5);
                }
                //SG
                if( $fiche->getNbsg1()!=$nbSg1){
                    $fiche->setNbsg1($nbSg1);
                }
                if( $fiche->getNbsg2()!=$nbSg2){
                    $fiche->setNbsg2($nbSg2);
                }
                if( $fiche->getNbsg3()!=$nbSg3){
                    $fiche->setNbsg3($nbSg3);
                }
                if( $fiche->getNbsg4()!=$nbSg4){
                    $fiche->setNbsg4($nbSg4);
                }
                if( $fiche->getNbsg5()!=$nbSg5){
                    $fiche->setNbsg5($nbSg5);
                }
                //Ecouvillon
                if( $fiche->getNbecouvnano()!=$nbEcouvnano){
                    $fiche->setNbecouvnano($nbEcouvnano);
                }
                if( $fiche->getNbecouvbucco()!=$nbEcouvbucco){
                    $fiche->setNbecouvbucco($nbEcouvbucco);
                }
              try {
                  $ficheDao->_em->beginTransaction();
                   $ficheDao->editer($fiche);
                   
                   
                   $ficheDao->_em->commit();
                    echo json_encode(array("type" => "success","message"=>"Enregistrement effectué avec succèss"));
              } catch (Exception $ex) {
                  $ficheDao->_em->rollBack();
                    echo json_encode(array("type" => "error","message"=>$ex->getMessage()));
              }
               
                
            }
            exit();
            
        }else{
           echo json_encode(array("type" => "error","msg"=>"Paramètres incorrects"));
            exit();
        }
        
       
    }

    
    public function datatableAction()
    {
        $table = 'fiches';

        $primaryKey = 'id';
        $columns = array(
            array('db' => 'formation' , 'dt' => 0),
            array('db' => 'id' , 'dt' => 1),
             array('db' => 'nbConsult' , 'dt' => 2),
            array('db' => 'nbFebrile' , 'dt' => 3),
             array('db' => 'nbIra' , 'dt' => 4),
            array('db' => 'nbSg' , 'dt' => 5),
            array('db' => 'semaine' , 'dt' => 6)
        );

        $sql_details = array(
            'user' => DB_USER,
            'pass' => DB_PASSWORD,
            'db' => DB_NAME,
            'host' => HOSTNAME
        );

        require(PUBLIC_PATH . '/files_to_include/ssp.class.php');

        $resultatDataTable = SSP::simple($_POST, $sql_details, $table, $primaryKey, $columns);
        $finalResult = array();
        $finalResult["draw"] = $resultatDataTable["draw"];
        $finalResult["recordsTotal"] = $resultatDataTable["recordsTotal"];
        $finalResult["recordsFiltered"] = $resultatDataTable["recordsFiltered"];
        $finalResult["data"] = array();
        foreach ( $resultatDataTable["data"] as $ligneTableau ){
            $id = $ligneTableau[1];
            $formation = $ligneTableau[0];
            $nbConsult = $ligneTableau[2];
            $nbFebrile = $ligneTableau[3];
            $nbIra = $ligneTableau[4];
            $nbSg = $ligneTableau[5];
            $semaine = $ligneTableau[6];
           
            $chaine = "";
            $newLine = array( $formation,$semaine,$nbConsult,$nbFebrile,$nbIra,$nbSg  );
            //$urlEditer = $this->_helper->url->url(array('controller' => 'Sms', 'action' => 'editer' , 'id' => $id));
            $chaine .= "<a data-toggle='modal' class='elementHeb' data-target='#modal-default' id='" . $id . "'><i title='modifier' class='fa fa-1x fa-edit clickcursor bluelink' ></i></a>";
            
            $newLine[] = utf8_encode($chaine);
            $finalResult["data"][] = $newLine;
        }
        
        echo json_encode($finalResult);
        exit();
    }
    




}







